
(defmeth browser-overlay-proto :click-button (i x y)
  (let* ((graph (slot-value 'graph))
         (lefts (send self :lefts))
         (box-width 10)
         (box-height 10)
         (topy 3)
         )
    (and (< (select lefts i) x (+ box-width (select lefts i)))
         (< topy y (+ topy box-height)))))

(defmeth browser-overlay-proto :show-datasheet-selector ()
  (send self :selector-state (not (send self :selector-state)))
  (send *datadesk* :show-datasheet-selector (send self :selector-state)))

(defmeth browser-overlay-proto :do-click (x y m1 m2)
  (send self :real-do-click x y m1 m2)
  (send self :redraw-the-overlay))


(defmeth browser-overlay-proto :real-do-click (x y m1 m2)
  (let* ((graph (slot-value 'graph))
         (dataobj (send graph :data-object))
         (lefts (send self :lefts))
         (nlefts (length lefts))
         (height 10)
         (width  10)
         (gap 2)
         (topx 10)
         (topy 3)
         (bottom (+ topy height gap))
         (idling (select (copy-list (list (send graph :idle-on))) 0))
         (i 0)
         )

; 0 HELP
    (when (and (< y bottom))
          (when (send self :help)
                (when (send self :click-button i x y)
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 15)
                      
                      (send self :draw-button nil i)
                      (send graph :plot-help)
                      (send graph :idle-on idling))
                (setf i (1+ i)))

          
; 1 retain
      
          (when (send self :retain-edit) 
                (when (send self :click-button i x y)        ;WHEN EDIT BUTTON CLICKED
                      (send graph :idle-on nil)  
                      (cond 
                        ((not (send graph :editable))        ;AND IN BROWSE MODE 
                         (send self :draw-button t i)        ;HIGHLIGHT BUTTON AND ASK IF
                         (when (two-button-dialog            ;WANT TO SWITCH TO EDITABLE
                                "DO YOU WANT TO EDIT YOUR DATA?" 
                                :first-button "YES: Edit Data" 
                                :second-button "NO: Do Not Edit")
                               (send graph :switch-editable) ;THEN SWITCH TO EDITABLE
                               (send self :retain-edit 'active)
                               (send self :discard 'active)
                               (send *workmap* :comatose t)
                               (send self :draw-button nil i)
                               (send self  :setup-redraw)
                               (send self  :redraw) 
                               ))
                        ;(send graph :edited t)
                        ;(send (send graph :data-object) :edited nil)
                        ;(send *workmap* :comatose t)
                        ((and (not (send graph :edited))
                              (send graph :editable))
                         (send graph :switch-edited)
                         (send graph :line-width 2)
                         (send self :draw-button t i 
                               :button-color 'red :text-color 'red)
                         (send graph :setup-redraw)
                         )
                        ((and (send graph :edited)
                              (send graph :editable))
                         (send graph :line-width 2)
                         (send self :draw-button t i 
                               :button-color 'red :text-color 'red)
                         (send graph :line-width 1)
                         (pause 30)
                         (cond
                           ((send dataobj :create-data (send $ :name)) 
                            (send self :draw-button nil i
                                  :button-color 'black :text-color 'black)
                            (send graph :line-width 1)
                            (send graph :edited nil)
                            (send graph :setup-redraw)
                            (pause 30))
                           (t
                            (send graph :line-width 2)
                            (send self :draw-button t i 
                                  :button-color 'red :text-color 'red)
                            (send graph :line-width 1)))
                         ))
                        
                      (send graph :idle-on idling)
                      );end when editable
                (setf i (1+ i))
                );end SAVE

          (when (send self :selector)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i) 
                      (pause 30)
                      (send self :show-datasheet-selector)
                     
                     ; (send self :draw-button (send self :selector-state) i) 
                      (send self :draw-button nil i) 
                      (send graph :idle-on idling))
                (setf i (1+ i)))

; discard
          (when (send self :discard)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 15)
                      (cond
                        ((not (SEND GRAPH :EDITED))
                         (send graph :hide-window))
                        ((two-button-dialog   
                          (format nil "WARNING!~%THIS WILL discard YOUR EDITING AND CLOSE THE DATASHEET~%ALL CHANGES WILL BE PERMANENTLY LOST~2%Are You Sure You Want To Do This?" )
                          :first-button "YES: discard, Close and Delete"
                          :second-button "NO: Leave Everything As Is.")
                         (send graph :hide-window)))
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))


 ; FORMAT
          (when (send self :format)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i) 
                      (pause 20)
                      (send graph :format)
                      ;(send self :expand t)
                      ;(send self :labels t)
                      (send self :setup-redraw)
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))

          ;5
          (when (send self :expand)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i) 
                      (send graph :expand-datasheet)
                      (pause 20)
                      (send self :draw-button nil i) 
                      (send graph :idle-on idling))
                (setf i (1+ i)))
                
          ;6
          (when (send self :labels)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i) 
                      (switch-label-variable)
                      (pause 20)
                      (send self :draw-button nil i) 
                      (send graph :idle-on idling))
                (setf i (1+ i)))
                                                                                                                                                                                                                                                                            
                
          ;7 
          (when (send self :top-most)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 20)
                      (send graph :top-most (not (send self :top-most)))
                      (send self :draw-button nil i)
                      (send graph :idle-on idling))
                (setf i (1+ i)))
          ;8
          (when (send self :maximize-button-showing)
                (when (and (< (select lefts i) x (+ width (select lefts i)))
                           (< topy y (+ topy height)))
                      (send graph :idle-on nil)
                      (send self :draw-button t i)
                      (pause 20)
                      (send graph :start-buffering)
                      (send self :switch-max-state)
                      (send self :setup-redraw)
                      (send self :draw-button nil i)
                      (send *max-datasheet-item* :enabled 
                                   (not (send self :max-state)))
                      (send *restore-layout-item* :enabled 
                                   (send self :max-state))
                      (send graph :buffer-to-screen)
                      (send graph :idle-on idling)))
          )))


